
LIBRARY ("Misc","1.6");
 FUNCTION_BLOCK wait_ms(time_in_ms)
  VAR
   tm:TIMER;
  END_VAR
  VAR_INPUT
   time_in_ms:INT;
  END_VAR
   START_TIMER(tm,time_in_ms);
   WAIT_UNTIL(EXPIRED(tm));
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK NUMBER_st()
  VAR
   num:INT;
  END_VAR
  VAR_INPUT
  END_VAR
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK copy_byte_arr(src,dst,offset_src,offset_dst,len)
  VAR
   ind_src:INT;
   ind_dst:INT;
  END_VAR
  VAR_INPUT
   src: ARRAY [0..1] OF BYTE;
   dst: ARRAY [0..1] OF BYTE;
   offset_src:INT;
   offset_dst:INT;
   len:INT;
  END_VAR
   ind_src:=offset_src;
   ind_dst:=offset_dst;
   WHILE (ind_src<(offset_src+len))DO
    dst[ind_dst]:=src[ind_src];
    ind_src:=ind_src+1;
    ind_dst:=ind_dst+1;
   END_WHILE
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK copy_byte_to_word_arr(src,dst,offset_src,offset_dst,len_words)
  VAR
   ind_src:INT;
   ind_dst:INT;
   tmp_ind:INT;
  END_VAR
  VAR_INPUT
   src: ARRAY [0..1] OF BYTE;
   dst: ARRAY [0..1] OF WORD;
   offset_src:INT;
   offset_dst:INT;
   len_words:INT;
  END_VAR
   ind_src:=offset_src;
   ind_dst:=offset_dst;
   WHILE (ind_src<(offset_src+2*len_words))DO
    tmp_ind:=ind_src+1;
    dst[ind_dst]:=SET_BITS(src[ind_src],8,8,src[tmp_ind]);
    ind_src:=ind_src+2;
    ind_dst:=ind_dst+1;
   END_WHILE
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK copy_word_to_byte_arr(src,dst,offset_src,offset_dst,len_words)
  VAR
   ind_src:INT;
   ind_dst:INT;
   tmp_ind:INT;
  END_VAR
  VAR_INPUT
   src: ARRAY [0..1] OF WORD;
   dst: ARRAY [0..1] OF BYTE;
   offset_src:INT;
   offset_dst:INT;
   len_words:INT;
  END_VAR
   ind_src:=offset_src;
   ind_dst:=offset_dst;
   WHILE (ind_src<(offset_src+len_words))DO
    dst[ind_dst]:=GET_BITS(src[ind_src],0,8);
    tmp_ind:=ind_dst+1;
    dst[tmp_ind]:=GET_BITS(src[ind_src],8,8);
    ind_src:=ind_src+1;
    ind_dst:=ind_dst+2;
   END_WHILE
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK compare_byte_arrays(arr1,arr2,len)
  VAR
   i:INT;
   res:INT;
  END_VAR
  VAR_INPUT
   arr1: ARRAY [0..1] OF BYTE;
   arr2: ARRAY [0..1] OF BYTE;
   len:INT;
  END_VAR
   res:=1;
   FOR i:=0 TO len-1 DO
     IF (arr1[i]<>arr2[i]) THEN
      res:=0;
    END_IF
   END_FOR
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK convArrToString(src,dst,offset_src,offset_dst,len)
  VAR
   ind_src:INT;
   ind_dst:INT;
  END_VAR
  VAR_INPUT
   src: ARRAY [0..1] OF BYTE;
   dst: ARRAY [0..1] OF CHAR;
   offset_src:INT;
   offset_dst:INT;
   len:INT;
  END_VAR
   ind_src:=offset_src;
   ind_dst:=offset_dst;
   WHILE (ind_src<(offset_src+len))DO
    dst[ind_dst]:=src[ind_src];
    ind_src:=ind_src+1;
    ind_dst:=ind_dst+1;
   END_WHILE
   dst[ind_dst]:=0;
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK compare_and_copy(curr_arr,prev_arr,num_elems)
  VAR
   i:INT;
   changed:INT;
  END_VAR
  VAR_INPUT
   curr_arr: ARRAY [0..1] OF BYTE;
   prev_arr: ARRAY [0..1] OF BYTE;
   num_elems:INT;
  END_VAR
   changed:=false;
   FOR i:=0 TO num_elems-1 DO
     IF (curr_arr[i]<>prev_arr[i]) THEN
      changed:=1;
    END_IF
    prev_arr[i]:=curr_arr[i];
   END_FOR
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK STR_AddSpecialChar(str1,char)
  VAR
   curr_len:INT;
  END_VAR
  VAR_INPUT
   str1: ARRAY [0..31] OF CHAR;
   char:BYTE;
  END_VAR
   curr_len:=STR_LEN(str1);
   str1[curr_len]:=char;
   curr_len:=curr_len+1;
   COMMENT("extend%20the%20string%20by%20null-terminating%20one%20char%20later");
   str1[curr_len]:=0;
 END_FUNCTION_BLOCK
 ENUM 
  CHAR_CARRIGE_RETURN:0xd
  ,CHAR_NEW_LINE:0xa
  ,CHAR_DOUBLE_QUOTE:0x22
 END_ENUM
 FUNCTION_BLOCK copy_byte_to_long_arr(src,dst,offset_src,offset_dst,len_longs)
  VAR
   ind_src:INT;
   ind_dst:INT;
  END_VAR
  VAR_INPUT
   src: ARRAY [0..1] OF BYTE;
   dst: ARRAY [0..1] OF INT;
   offset_src:INT;
   offset_dst:INT;
   len_longs:INT;
  END_VAR
   ind_src:=offset_src;
   ind_dst:=offset_dst;
   WHILE (ind_src<(offset_src+4*len_longs))DO
    dst[ind_dst]:=LE_GET_32BIT(src,ind_src);
    ind_src:=ind_src+4;
    ind_dst:=ind_dst+1;
   END_WHILE
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK copy_long_to_byte_arr(src,dst,offset_src,offset_dst,len_longs)
  VAR
   ind_src:INT;
   ind_dst:INT;
  END_VAR
  VAR_INPUT
   src: ARRAY [0..1] OF INT;
   dst: ARRAY [0..1] OF BYTE;
   offset_src:INT;
   offset_dst:INT;
   len_longs:INT;
  END_VAR
   ind_src:=offset_src;
   ind_dst:=offset_dst;
   WHILE (ind_src<(offset_src+len_longs))DO
    LE_SET_32BIT(dst,ind_dst,src[ind_src]);
    ind_src:=ind_src+1;
    ind_dst:=ind_dst+4;
   END_WHILE
 END_FUNCTION_BLOCK