
LIBRARY ("IO_Library","1.2");
 ENUM 
  DS_RESOURCE_BUSY:0xff80c200
 END_ENUM
 FUNCTION_BLOCK TBEN_IOL_AsyncWrite(port_num,index,sub_index,wr_data,wr_data_len,Error_Code)
   VAR
    ind1:INT;
    ds_tx_arr: ARRAY [0..127] OF BYTE;
    ds_rx_arr: ARRAY [0..127] OF BYTE;
    res:INT;
    read_res:INT;
    cnt:INT;
    err_data_len:INT;
    tmp:INT;
   END_VAR
   VAR_INPUT
    port_num:INT;
    index:INT;
    sub_index:INT;
    wr_data: ARRAY [0..127] OF BYTE;
    wr_data_len:INT;
    Error_Code: ARRAY [0..7] OF BYTE;
   END_VAR
    COMMENT("Slot");
    LE_SET_32BIT(ds_tx_arr,0,port_num+1);
    COMMENT("DSID");
    LE_SET_32BIT(ds_tx_arr,4,0x11F6);
    COMMENT("Write%20Request%20(2-%3E%20Write)");
    ARRAY_INIT(ds_tx_arr,8,8,0,0xFE,0x4A,2);
    ds_tx_arr[9]:=port_num;
    BE_SET_16BIT(ds_tx_arr,13,index);
    ds_tx_arr[15]:=sub_index;
    FOR cnt:=0 TO wr_data_len-1 DO
     ind1:=16+cnt;
     ds_tx_arr[ind1]:=wr_data[cnt];
    END_FOR
    res:=WRITE_DS(0,ds_tx_arr,16+wr_data_len);
    trace ("Write Started",port_num );
    res:=READ_DS(0,ds_rx_arr,res);
    LE_SET_32BIT(ds_tx_arr,0,port_num+1);
    LE_SET_32BIT(ds_tx_arr,4,0x11F7);
    read_res:=-1;
    WHILE (read_res<0)DO
     res:=WRITE_DS(0,ds_tx_arr,8);
     read_res:=READ_DS(0,ds_rx_arr,read_res);
     WAIT_UNTIL(1);
    END_WHILE
    FOR err_data_len:=0 TO 7 DO
     tmp:=12+err_data_len;
     Error_Code[err_data_len]:=ds_rx_arr[tmp];
     WAIT_UNTIL(1);
    END_FOR
    trace ("Write Complete",port_num );
  END_FUNCTION_BLOCK
 
Function_Block TBEN_IOL_AsyncRead(port_num,index,sub_index,res_data,Error_Code)
   VAR
    res_data_len:INT;
    ds_tx_arr: ARRAY [0..127] OF BYTE;
    ds_rx_arr: ARRAY [0..127] OF BYTE;
    res:INT;
    read_res:INT;
    tmp:INT;
    err_data_len:INT;
   END_VAR
   VAR_INPUT
    port_num:INT;
    index:INT;
    sub_index:INT;
    res_data: ARRAY [0..4] OF BYTE;
    Error_Code: ARRAY [0..7] OF BYTE;
   END_VAR
    COMMENT("Clear%20out%20array");
    ARRAY_INIT(ds_tx_arr,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
    COMMENT("Slot");
    LE_SET_32BIT(ds_tx_arr,0,port_num+1);
    COMMENT("DSID");
    LE_SET_32BIT(ds_tx_arr,4,0x11F6);
    COMMENT("Write%20Request");
    ARRAY_INIT(ds_tx_arr,8,8,0,0xFE,0x4A,3);
    ds_tx_arr[9]:=port_num;
    BE_SET_16BIT(ds_tx_arr,13,index);
    ds_tx_arr[15]:=sub_index;
    res:=WRITE_DS(0,ds_tx_arr,16);
    res:=READ_DS(0,ds_rx_arr,read_res);
    trace ("Read Started",port_num );
    COMMENT("Read%20Response");
    LE_SET_32BIT(ds_tx_arr,0,port_num+1);
    LE_SET_32BIT(ds_tx_arr,4,0x11F7);
    read_res:=-1;
    WHILE (read_res<0)DO
     res:=WRITE_DS(0,ds_tx_arr,8);
     read_res:=READ_DS(0,ds_rx_arr,read_res);
     WAIT_UNTIL(1);
    END_WHILE
    FOR res_data_len:=0 TO read_res-16-1 DO
     tmp:=16+res_data_len;
     res_data[res_data_len]:=ds_rx_arr[tmp];
     WAIT_UNTIL(1);
    END_FOR
    FOR err_data_len:=0 TO 7 DO
     tmp:=12+err_data_len;
     Error_Code[err_data_len]:=ds_rx_arr[tmp];
     WAIT_UNTIL(1);
    END_FOR
    trace ("Readout complete",port_num );
  END_FUNCTION_BLOCK
 FUNCTION_BLOCK TBEN_S2_RFID_READ(channel,offset,length,output_arr,arr_offset)
  VAR
   arr_offR:INT;
   offR:INT;
   lenR:INT;
   ctrl_slot:INT;
   input_slot:INT;
   lenI:INT;
  END_VAR
  VAR_INPUT
   channel:INT;
   offset:INT;
   length:INT;
   output_arr: ARRAY [0..1] OF BYTE;
   arr_offset:INT;
  END_VAR
    IF (channel = 1) THEN
     ctrl_slot:=TBEN_S_RFID_CHAN_1_CTRL_STATUS_SLOT;
     input_slot:=TBEN_S_RFID_CHAN_1_INP_STATUS_SLOT;
    ELSIF (channel = 2)
     ctrl_slot:=TBEN_S_RFID_CHAN_2_CTRL_STATUS_SLOT;
     input_slot:=TBEN_S_RFID_CHAN_2_INP_STATUS_SLOT;
   END_IF
   lenR:=length;
   lenI:=length;
   offR:=offset;
   arr_offR:=arr_offset;
   WHILE (lenI > 0)DO
    lenR:=min(64,lenI);
    COMMENT("Write%20CTRL%20Output%20length%20");
    SET_IO_OUTP_INT(ctrl_slot,64,16,lenR);
    COMMENT("Write%20CTRL%20Output%20Start%20Address%20for%20read%20access%20(Basically%20the%20offset%20provided%20in%20the%20argument%20)");
    SET_IO_OUTP_INT(ctrl_slot,32,32,offR);
    COMMENT("Write%20CTRL%20Output%20Command%20Code%20to%202");
    SET_IO_OUTP_INT(ctrl_slot,0,16,2);
    COMMENT("Wait%20until%20transaction%20is%20done.%20");
    WAIT_UNTIL(GET_IO_INP_INT(ctrl_slot,0,16) = 2);
    GET_IO_INP_ARR(input_slot,output_arr,arr_offR,0,lenR);
    SET_IO_OUTP_INT(ctrl_slot,0,16,0);
    WAIT_UNTIL(GET_IO_INP_INT(ctrl_slot,0,16) = 0);
    lenI:=lenI- 64;
    offR:=offR + 64;
    arr_offR:=arr_offR + 64;
   END_WHILE
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK TBEN_S2_RFID_WRITE(channel,offset,length,source_arr,arr_offset)
  VAR
   arr_offW:INT;
   offW:INT;
   lenW:INT;
   ctrl_slot:INT;
   output_slot:INT;
   lenI:INT;
  END_VAR
  VAR_INPUT
   channel:INT;
   offset:INT;
   length:INT;
   source_arr: ARRAY [0..1] OF BYTE;
   arr_offset:INT;
  END_VAR
    IF (channel = 1) THEN
     ctrl_slot:=TBEN_S_RFID_CHAN_1_CTRL_STATUS_SLOT;
     output_slot:=TBEN_S_RFID_CHAN_1_OUTP_STATUS_SLOT;
    ELSIF (channel = 2)
     ctrl_slot:=TBEN_S_RFID_CHAN_2_CTRL_STATUS_SLOT;
     output_slot:=TBEN_S_RFID_CHAN_2_OUTP_STATUS_SLOT;
   END_IF
   lenW:=length;
   lenI:=length;
   offW:=offset;
   arr_offW:=arr_offset;
   WHILE (lenI > 0)DO
    lenW:=min(64,lenI);
    COMMENT("Write%20CTRL%20Output%20length%20");
    SET_IO_OUTP_INT(ctrl_slot,64,16,lenW);
    COMMENT("Write%20CTRL%20Output%20Start%20Address%20for%20read%20access%20(Basically%20the%20offset%20provided%20in%20the%20argument%20)");
    SET_IO_OUTP_INT(ctrl_slot,32,32,offW);
    COMMENT("Write%20the%20stuff%20down%20in%20the%20RFID%20tag");
    SET_IO_OUTP_ARR(output_slot,source_arr,arr_offW,0,lenW);
    COMMENT("Write%20CTRL%20Output%20Command%20Code%20to%204");
    SET_IO_OUTP_INT(ctrl_slot,0,16,4);
    WAIT_UNTIL(GET_IO_INP_INT(ctrl_slot,0,16) = 4);
    SET_IO_OUTP_INT(ctrl_slot,0,16,0);
    WAIT_UNTIL(GET_IO_INP_INT(ctrl_slot,0,16) = 0);
    lenI:=lenI - 64;
    offW:=offW + 64;
    arr_offW:=arr_offW + 64;
   END_WHILE
 END_FUNCTION_BLOCK
 ENUM 
  TBEN_S_RFID_CHAN_1_CTRL_STATUS_SLOT:1
  ,TBEN_S_RFID_CHAN_1_INP_STATUS_SLOT:2
  ,TBEN_S_RFID_CHAN_1_OUTP_STATUS_SLOT:3
  ,TBEN_S_RFID_CHAN_2_CTRL_STATUS_SLOT:4
  ,TBEN_S_RFID_CHAN_2_INP_STATUS_SLOT:5
  ,TBEN_S_RFID_CHAN_2_OUTP_STATUS_SLOT:6
 END_ENUM
 FUNCTION_BLOCK BLCEN_RFIDS_Read(slot,channel,offset,res_data,num_bytes_to_read)
  VAR
   curr_pos:INT;
   be_addr_arr: ARRAY [0..1] OF BYTE;
   to_copy:INT;
   result:INT;
  END_VAR
  VAR_INPUT
   slot:INT;
   channel:INT;
   offset:INT;
   res_data: ARRAY [0..1] OF BYTE;
   num_bytes_to_read:INT;
  END_VAR
   curr_pos:=0;
   WHILE ((curr_pos<num_bytes_to_read)&(GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=0))DO
    COMMENT("Convert%20offset%20to%20big%20endian");
    BE_SET_16BIT(be_addr_arr,0,offset+curr_pos);
    COMMENT("Write%20big%20endian%20value%20of%20offset%20to%20IO");
    SET_IO_OUTP_ARR(slot,be_addr_arr,0,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET+RFIDS_ADDR_BYTE_OFFSET,2);
    to_copy:=min(8,num_bytes_to_read-curr_pos);
    COMMENT("Write%20number%20of%20bytes%20to%20read%20to%20IO");
    SET_IO_OUTP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_LEN_BYTE_OFFSET*8,3,to_copy-1);
    COMMENT("Trigger%20read,%20wait%20done%20bit%20to%20go%20low,%20clear%20read,%20wait%20done%20bit%20to%20go%20high");
    SET_IO_OUTP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_READ_CMD_BIT,1,1);
    WAIT_UNTIL((GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_DONE_BIT,1)=0)|(GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=1));
    SET_IO_OUTP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_READ_CMD_BIT,1,0);
    WAIT_UNTIL((GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_DONE_BIT,1)=1)|(GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=1));
    COMMENT("Copy%20the%20RX%20data%20into%20the%20user%20array%20and%20increment%20array%20position");
    GET_IO_INP_ARR(slot,res_data,curr_pos,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET+RFIDS_DATA_BYTE_OFFSET,to_copy);
    curr_pos:=curr_pos+to_copy;
   END_WHILE
    IF ((GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=1)) THEN
     result:=false;
    ELSE
     result:=true;
   END_IF
 END_FUNCTION_BLOCK
 FUNCTION_BLOCK BLCEN_RFIDS_Write(slot,channel,offset,outp_data,num_bytes_to_write)
  VAR
   curr_pos:INT;
   be_addr_arr: ARRAY [0..1] OF BYTE;
   to_copy:INT;
   result:INT;
  END_VAR
  VAR_INPUT
   slot:INT;
   channel:INT;
   offset:INT;
   outp_data: ARRAY [0..1] OF BYTE;
   num_bytes_to_write:INT;
  END_VAR
   curr_pos:=0;
   WHILE ((curr_pos<num_bytes_to_write)&(GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=0))DO
    COMMENT("Convert%20offset%20to%20big%20endian");
    BE_SET_16BIT(be_addr_arr,0,offset+curr_pos);
    COMMENT("Write%20big%20endian%20value%20of%20offset%20to%20IO");
    SET_IO_OUTP_ARR(slot,be_addr_arr,0,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET+RFIDS_ADDR_BYTE_OFFSET,2);
    to_copy:=min(8,num_bytes_to_write-curr_pos);
    COMMENT("Copy%20the%20TX%20data%20from%20user%20array");
    SET_IO_OUTP_ARR(slot,outp_data,curr_pos,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET+RFIDS_DATA_BYTE_OFFSET,to_copy);
    COMMENT("Write%20number%20of%20bytes%20to%20write%20to%20IO");
    SET_IO_OUTP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_LEN_BYTE_OFFSET*8,3,to_copy-1);
    COMMENT("Trigger%20read,%20wait%20done%20bit%20to%20go%20low,%20clear%20read,%20wait%20done%20bit%20to%20go%20high");
    SET_IO_OUTP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_WRITE_CMD_BIT,1,1);
    WAIT_UNTIL((GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_DONE_BIT,1)=0)|(GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=1));
    SET_IO_OUTP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_WRITE_CMD_BIT,1,0);
    WAIT_UNTIL((GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_DONE_BIT,1)=1)|(GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=1));
    curr_pos:=curr_pos+to_copy;
   END_WHILE
    IF ((GET_IO_INP_INT(slot,channel*RFIDS_SECOND_CHANNEL_BYTE_OFFSET*8+RFIDS_ERR_BIT,1)=1)) THEN
     result:=false;
    ELSE
     result:=true;
   END_IF
 END_FUNCTION_BLOCK
 ENUM 
  RFIDS_DONE_BIT:7
  ,RFIDS_ERR_BIT:5
  ,RFIDS_READ_CMD_BIT:4
  ,RFIDS_WRITE_CMD_BIT:3
  ,RFIDS_RESET_CMD_BIT:0
  ,RFIDS_SECOND_CHANNEL_BYTE_OFFSET:12
  ,RFIDS_ADDR_BYTE_OFFSET:2
  ,RFIDS_LEN_BYTE_OFFSET:1
  ,RFIDS_DATA_BYTE_OFFSET:4
 END_ENUM